#version 120




uniform sampler2D texture;
uniform sampler2D lightmap;
uniform float rainStrength;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

varying float iswater;
varying float distance;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

uniform int fogMode;






void main() {	
	
	vec2 adjustedTexCoord = texcoord.st;
	float texinterval = 0.0625f;


				  

    
    vec4 tex = texture2D(texture, adjustedTexCoord);

		
    if (tex.r > 0.99 && tex.b > 0.99 && tex.g < 0.1f) {
		tex = vec4(0.9f, 0.9f, 0.9f, 0.15f);
	}
	
    vec4 lightmap = texture2D(lightmap, lmcoord.st);
    		if (fogMode == GL_EXP) {
			lightmap = mix(lightmap, vec4(0.0f, 0.0f, 1.0f, 1.0f),  1.0f - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
		} else if (fogMode == GL_LINEAR) {
			lightmap = mix(lightmap, vec4(0.0f, 0.0f, 1.0f, 1.0f),  clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
		}
		
	gl_FragData[0] = vec4((tex * color *(lightmap.b+lightmap.r+lightmap.g)).rgb*vec3(0.5,0.5,1.0),0.75);
	gl_FragData[1] = vec4(vec2(gl_FragCoord.z), gl_FragCoord.z, 1.0);
	
	
	gl_FragData[4] = vec4(0.0, iswater, 1.0, 1.0);
	
	//store lightmap in auxilliary texture. r = torch light. g = lightning. b = sky light.
	
	
		

	
	
	gl_FragData[5] = vec4(0.0);
	


	if (fogMode == GL_EXP) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	} else if (fogMode == GL_LINEAR) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
	}
}